// Home Page 1 

$(function () {
    var owl = $('.testimonials-con .owl-carousel');
    owl.owlCarousel({
        margin: 30,
        nav: false,
        loop: true,
        dots: true,
        autoplay: true,
        autoplayTimeout: 4500,
        responsive: {
            0: {
                items: 1
            },
            576: {
                items: 1
            },
            768: {
                items: 2
            },
            992: {
                items: 3
            }
        }
    })
})

// AWARDS SECTION carousel js
$(function () {
    var owl = $('.awards-con .owl-carousel');

    function initializeCarousel(marginValue) {
        owl.owlCarousel('destroy'); // Destroy existing instance if any
        owl.owlCarousel({
            margin: marginValue,
            nav: true,
            loop: true,
            dots: false,
            navText: [
                "<img src='./assets/images/left-arrow.webp' alt='Previous' class='nav-arrow'>",
                "<img src='./assets/images/right-arrow.webp' alt='Next' class='nav-arrow'>"
            ],

            autoplay: true,
            autoplayTimeout: 6000,
            responsive: {
                0: {
                    items: 1
                },
                576: {
                    items: 3
                },
                768: {
                    items: 4
                },
                992: {
                    items: 5
                },
                1200: {
                    items: 5
                },
                1500: {
                    items: 5
                }
            }
        });
    }

    function adjustMargin() {
        if (window.innerWidth <= 991) {
            initializeCarousel(15);
        }
        if (window.innerWidth <= 1199) {
            initializeCarousel(20);
        }
        if (window.innerWidth <= 1440) {
            initializeCarousel(0);
        } else {
            initializeCarousel(44); // Default margin for larger screens
        }
    }

    // Initial call to set the correct margin
    adjustMargin();

    // Adjust carousel on window resize
    $(window).on('resize', function () {
        adjustMargin();
    });
});

$(function () {

    // Open Sidebar
    $(document).on("click", "#openSidebarBtn", function () {
        $("#rightSidebar").addClass("active");
        // $("#openSidebarBtn").hide(); 
    });

    // Close Sidebar
    $(document).on("click", "#closeSidebarBtn", function () {
        $("#rightSidebar").removeClass("active");
        // $("#openSidebarBtn").show(); 
    });

});

$(function () {
    var owl = $('.explore-products .owl-carousel');
    owl.owlCarousel({
        margin: 30,
        nav: false,
        loop: true,
        dots: true,
        autoplay: true,
        autoplayTimeout: 4500,
        responsive: {
            0: {
                items: 1
            },
            576: {
                items: 1
            },
            768: {
                items: 2
            },
            992: {
                items: 3
            },
            1200: {
                items: 4
            }
        }
    })
})

document.querySelectorAll('.like-btn').forEach(btn => {
    btn.addEventListener('click', function () {
        this.classList.toggle('liked');
    });
});
// 
$(function () {
    // Declare the body variable
    var $body = $("body");

    // Function that shows and hides the sidebar cart
    $(".cart-button, .close-button, #sidebar-cart-curtain").click(function (e) {
        e.preventDefault();

        // Add the show-sidebar-cart class to the body tag
        $body.toggleClass("show-sidebar-cart");

        // Check if the sidebar curtain is visible
        if ($("#sidebar-cart-curtain").is(":visible")) {
            // Hide the curtain
            $("#sidebar-cart-curtain").fadeOut(500);
        } else {
            // Show the curtain
            $("#sidebar-cart-curtain").fadeIn(500);
        }
    });

    // Function that adds or subtracts quantity when a 
    // plus or minus button is clicked
    $body.on('click', '.plus-button, .minus-button', function () {
        // Get quanitity input values
        var qty = $(this).closest('.qty').find('.qty-input');
        var val = parseFloat(qty.val());
        var max = parseFloat(qty.attr('max'));
        var min = parseFloat(qty.attr('min'));
        var step = parseFloat(qty.attr('step'));

        // Check which button is clicked
        if ($(this).is('.plus-button')) {
            // Increase the value
            qty.val(val + step);
        } else {
            // Check if minimum button is clicked and that value is 
            // >= to the minimum required
            if (min && min >= val) {
                // Do nothing because value is the minimum required
                qty.val(min);
            } else if (val > 0) {
                // Subtract the value
                qty.val(val - step);
            }
        }
    });
});

// BOOKING FORM fUNCTIONAL

$(function () {

    let selectedSlot = null;

    function resetBoxes() {
        $("#availabilityBox, #confirmationBox, #largeGroupBox, #errorBox").addClass("d-none");
        selectedSlot = null;
    }

    function resetReservation() {
        resetBoxes();
        $("#reservationForm")[0].reset();
        $("#validationMsg").addClass("d-none");
    }

    window.resetReservation = resetReservation;

    $("#reservationForm").on("submit", function (e) {
        e.preventDefault();

        const date = $("#res-date").val();
        const time = $("#res-time").val();
        const guests = $("#res-guests").val();

        $("#validationMsg").addClass("d-none");
        resetBoxes();

        if (!date || !time || !guests) {
            $("#validationMsg")
                .text("Please select Date, Time and Guests.")
                .removeClass("d-none");
            return;
        }

        // 10+ guests logic
        if (guests === "10+") {
            $("#largeGroupBox").removeClass("d-none");
            return;
        }

        // Mock unavailable logic
        if (time >= "21:30" || parseInt(guests) > 8) {
            $("#errorBox").removeClass("d-none");
            return;
        }

        // Availability slots
        const slots = ["6:30 PM", "7:00 PM", "7:30 PM", "8:00 PM"];
        $("#slots").empty();

        $.each(slots, function (i, t) {
            const btn = $(
                `<button type="button" class="btn btn-outline-success mr-2 mb-2">${t}</button>`
            );

            btn.on("click", function () {
                $("#slots button").removeClass("active btn-success")
                    .addClass("btn-outline-success");
                $(this).addClass("active btn-success")
                    .removeClass("btn-outline-success");
                selectedSlot = t;
            });

            $("#slots").append(btn);
        });

        $("#availabilityBox").removeClass("d-none");
    });

    $("#confirmBtn").on("click", function () {
        if (!selectedSlot) return;

        $("#availabilityBox").addClass("d-none");
        $("#confirmationBox")
            .html(
                `<h5 class="text-size-20">Reservation Confirmed!</h5>
                 <p>Your table is booked at <strong>${selectedSlot}</strong>.</p>`
            )
            .removeClass("d-none");
    });

});



// PREALOADER

$(function () {

    // Thora sa smooth effect ke liye short delay (optional)
    setTimeout(function () {
        $('#preloader').addClass('hidden-complete');

        setTimeout(function () {
            $('#preloader').remove();
        }, 500);

    }, 300); // sirf 0.3 sec

});

$(function () {

    // DESKTOP: hover dropdown with delay
    if ($(window).width() > 991) {

        $('.header-con .dropdown').hover(
            function () {
                const $this = $(this);
                clearTimeout($this.data('timeout'));
                $this.addClass('show');
                $this.find('.dropdown-menu').addClass('show');
            },
            function () {
                const $this = $(this);
                const timeout = setTimeout(function () {
                    $this.removeClass('show');
                    $this.find('.dropdown-menu').removeClass('show');
                }, 200); // smooth delay like premium menus

                $this.data('timeout', timeout);
            }
        );

        // prevent click toggle conflict
        $('.header-con .dropdown-toggle').click(function (e) {
            e.preventDefault();
        });
    }

    // MOBILE: click behavior (default bootstrap but smoother)
    $('.header-con .dropdown-toggle').on('click', function (e) {
        if ($(window).width() <= 991) {
            e.preventDefault();
            const parent = $(this).parent();
            parent.toggleClass('show');
            parent.find('.dropdown-menu').toggleClass('show');
        }
    });

});
$(function () {
    toggleDropdown();
});

$(window).on('resize', function () {
    toggleDropdown();
});

function toggleDropdown() {
    let width = $(window).width();
    let dropdown = $('.header-con .dropdown-toggle')

    if (width <= 991) {
        dropdown.removeAttr('data-toggle');
    } else {
        dropdown.attr('data-toggle', 'dropdown');
    }
}
// 
// form.addEventListener("submit", function (e) {
//     if (!form.checkValidity()) {
//         e.preventDefault();
//         form.classList.add("was-validated");
//     }
// });
// const timeInput = form.querySelector('input[name="time"]');

// timeInput.addEventListener("change", function () {
//     const hour = parseInt(this.value.split(":")[0]);

//     if (hour < 10 || hour > 22) {
//         alert("Please select a time between 10 AM and 10 PM");
//         this.value = "";
//     }
// });