function increaseValue(button, limit) {
    let btn = $(button);
    let product = btn.closest('.product');

    if (product.length === 0) {
        let number = btn.parent().find('.number');

        let value = parseInt(number.html(), 10);
        if (isNaN(value)) value = 0;

        if (limit && value >= limit) return;

        number.html(value + 1);
        return;
    }

    let qtyEl = product.find('.number');
    let target = product.find('.product-line-price span');

    let qty = parseInt(qtyEl.text());
    let price = parseFloat(product.find('.product-price').text());

    qty++;
    qtyEl.text(qty);
    target.text((price * qty).toFixed(2));

    updateTotal(true);
}

function decreaseValue(button, limit = 1) {
    let btn = $(button);
    let product = btn.closest('.product');

    if (product.length === 0) {
        let number = btn.parent().find('.number');

        let value = parseInt(number.html(), 10);
        if (isNaN(value)) value = 0;

        if (limit && value <= limit) return;

        number.html(value - 1);
        return;
    }

    let qtyEl = product.find('.number');
    let target = product.find('.product-line-price span');

    let qty = parseInt(qtyEl.text());
    let price = parseFloat(product.find('.product-price').text());

    if (qty > 1) {
        qty--;
        qtyEl.text(qty);
        target.text((price * qty).toFixed(2));
    }

    updateTotal(true);
}

function updateTotal(cart = false) {
    let elements = $(cart ? '.shopping-cart .product' : '#sidebar-cart .product');
    let subtotalElement = $(cart ? '.cart-total-outer .sub-total' : '#sidebar-cart .sub-total');

    let subtotal = 0;
    $.each(elements, function (i, el) {
        subtotal += parseFloat($(el).find('.product-line-price span').text());
    });

    subtotalElement.find('.dollar').text('$' + subtotal.toFixed(2));
    if (cart) {
        let shipping = parseFloat($('.shipping-total .dollar').text());

        let total = subtotal + shipping;

        $('.total .dollar').text('$' + total.toFixed(2));
    }
}